%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for educational purposes 
%   associated with the book
%
%
%


% Another field visualization using quiver --
% three equal point charges residing at vertices of an equilateral triangle 


clear all;
close all;

Eps0 = 8.8542 * 10^(-12);
a = input('Basis of a equilateral triangle at the origin in cm: ');
a = a*10^(-2);
b = a*sqrt(3)/2;
Q = input('Charge placed at each corner of a triangle in nC: ');
Q = Q *10^(-9);
v = -0.75*a: 0.75*a/11: 0.75*a;
u = -0.2*b: 1.6*b/11:1.4*b;
[x,y] = meshgrid(v,u);
xtr = [-b/2 b/2 0 ];
ytr = [0 0 a];

[N,M] = size(x);
for i = 1 : N
    for t = 1 : M
        for j = 1 : length(xtr)
            r(i,t,j,:) = [x(i,t) - xtr(j) y(i,t) - ytr(j)];
            rabs(i,t,j) = vectorMag(r(i,t,j,:));
            runit(i,t,j,:) = r(i,t,j,:)/rabs(i,t,j);
            E(i,t,j,:) = Q*runit(i,t,j,:)/(4*pi*Eps0*rabs(i,t,j)^2);
        end;
    Etotx(i,t) = sum(E(i,t,:,1));
    Etoty(i,t) = sum(E(i,t,:,2));
    end;
end;

hold on;
for j = 1 : length(xtr)
plot(xtr(j),ytr(j),'bo','MarkerSize',5,'MarkerFaceColor','r');
end;
quiver(x,y,Etotx,Etoty);
axis equal;
hold off;